Test_Gravity = class()

function Test_Gravity:init()
    self.title = "variable gravity scale"
    self.unit = WIDTH * 0.04
end

function Test_Gravity:setup()
    self.lab = PhysicsLab()   
    self.lab:makePetrieDish()
    local circle1 = self.lab:circleAt(WIDTH*0.25, HEIGHT/2, self.unit)
    
    local circle2 = self.lab:circleAt(WIDTH*0.5, HEIGHT/2, self.unit * 3)
    circle2.gravityScale = 0.5
    
    local circle3 = self.lab:circleAt(WIDTH*0.75, HEIGHT/2, self.unit * 2.2)
    circle3.gravityScale = 0.25
    
    print("This test demonstrates the 'gravityScale' setting of physics bodies.\n\nThe smallest circle uses normal gravity, the largest uses half-gravity, and the medium-sized circle uses one-quarter gravity.")
end

function Test_Gravity:draw()
    self.lab:draw()
end

function Test_Gravity:touched(touch)
    self.lab:touched(touch)
end

function Test_Gravity:collide(contact)
    self.lab:collide(contact)
end

function Test_Gravity:cleanup()
    self.lab:clear()
end
